@extends('layouts.app')

@section('content')
<div class="pcoded-content">
    <div class="pcoded-inner-content">
        <div class="main-body">
            <div class="page-wrapper">
            	<div class="page-body">
            		<div class="row">
                        <!-- Drill Down Chart -->
                        <div class="col-md-12 col-lg-12">
                            <div class="card">

                                <div class="card-block">
                                    <div id="top_districts"></div>
                                </div>
                            </div>
                        </div>
                        <!-- Drill Down End -->

                        <!-- National Status start -->
                        <div class="col-md-12 col-lg-6">
                            <div class="card">

                                <div class="card-block">
                                    <div id="national_status"></div>
                                </div>
                            </div>
                        </div>
                        <!-- National Status Ends -->

                        <!-- Regions start -->
                        <div class="col-md-12 col-lg-6">
                            <div class="card">

                                <div class="card-block">
                                    <div id="regions"></div>
                                </div>
                            </div>
                        </div>
                        <!-- Regions Ends -->

                        <!-- Bar Chart start -->
                        <div class="col-md-12 col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5>Incidents By Gender</h5>
                                    <span>Number of Incidents disagregated by gender</span>
                                    <div class="card-header-right">
                                        <i class="icofont icofont-spinner-alt-5"></i>                                                         </div>
                                </div>
                                <div class="card-block">
                                    <div id="morris-bar-chart" style="overflow-x:scroll; height: 400px;"></div>
                                </div>
                            </div>
                        </div>
                        <!-- Bar Chart Ends -->
                        <!-- LINE CHART start -->
                        <div class="col-md-12 col-lg-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5>Trends</h5>
                                    <span>Trends of Incidents across the Years</span>
                                </div>
                                <div class="card-block">
                                    <div id="line-example"></div>
                                </div>
                            </div>
                        </div>
                        <!-- LINE CHART Ends -->
                        <!-- Donut chart start -->
                        <div class="col-md-12 col-lg-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5>Number of Incidents</h5>
                                    <span>Total number of Incidents separated by Incident Category</span>
                                    <div class="card-header-right">
                                        <i class="icofont icofont-spinner-alt-5"></i>                                                         </div>
                                </div>
                                <div class="card-block">
                                    <div id="donut-example"></div>
                                </div>
                            </div>
                        </div>
                        <!-- Donut chart Ends -->
                        <!-- Area Chart start -->
                        <div class="col-lg-12" style="visibility: hidden; height: 0px;">
                            <div class="card">
                                <div class="card-header">
                                    <h5>Area chart</h5>
                                    <span></span>
                                    <div class="card-header-right">
                                        <i class="icofont icofont-spinner-alt-5"></i>                                                         </div>
                                    </div>
                                    <div class="card-block">
                                        <div id="area-example"></div>
                                    </div>
                            </div>
                        </div>
                        <!-- Area Chart Ends -->

                    </div>
	            </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    // Data retrieved from https://gs.statcounter.com/browser-market-share#monthly-202201-202201-bar

    // Create the chart
    Highcharts.chart('top_districts', {
        chart: {
            type: 'column'
        },
        title: {
            align: 'left',
            text: 'Districts with the Highest Incident Rates'
        },
        subtitle: {
            align: 'left',
            text: ''
        },
        accessibility: {
            announceNewData: {
                enabled: true
            }
        },
        xAxis: {
            type: 'category'
        },
        yAxis: {
            title: {
                text: 'Total Number of Incidents'
            }

        },
        legend: {
            enabled: false
        },
        plotOptions: {
            series: {
                borderWidth: 0,
                dataLabels: {
                    enabled: true,
                    format: '{point.y:.1f}'
                }
            }
        },

        tooltip: {
            headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
            pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.2f}</b><br/>'
        },

        series: [
            {
                name: 'Districts',
                colorByPoint: true,
                data: [
                    @foreach($incidents as $incident)
                        {
                            name: '{{ $incident->name }}',
                            y: {{ $incident->y }},
                            drilldown: '{{ $incident->drilldown }}'
                        },
                    @endforeach
                ]
            }
        ],
        drilldown: {
            breadcrumbs: {
                position: {
                    align: 'right'
                }
            },
            series: [
                @foreach($incidents as $incident)
                    {
                        name: '{{ $incident->name }}',
                        id: '{{ $incident->name }}',
                        data: [
                            <?php
                                $incidentdata = getNumberofIncidentsbyDistrict($incident->districtid);
                            ?>
                            @foreach($incidentdata as $incidentvalue)
                                [
                                    '{{ $incidentvalue->incidentname }}',
                                    {{ $incidentvalue->incidents }}
                                ],
                            @endforeach
                        ]
                    },
                @endforeach
            ]
        }
    });

</script>

<script type="text/javascript">
    // Create the chart
    Highcharts.chart('national_status', {
        chart: {
            type: 'pie'
        },
        title: {
            text: 'Incidents Statistics by National Status',
            align: 'left'
        },
        subtitle: {
            text: '',
            align: 'left'
        },

        accessibility: {
            announceNewData: {
                enabled: true
            },
            point: {
                valueSuffix: '%'
            }
        },

        plotOptions: {
            series: {
                borderRadius: 5,
                dataLabels: {
                    enabled: true,
                    format: '{point.name}: {point.y:.1f}'
                }
            }
        },

        tooltip: {
            headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
            pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.2f}</b> of total<br/>'
        },

        series: [
            {
                name: 'National Status',
                colorByPoint: true,
                data: [
                    @foreach($nationalstatus as $nationalstate)
                        {
                            name: '{{ $nationalstate->name }}',
                            y: {{ $nationalstate->y }},
                            drilldown: '{{ $nationalstate->drilldown }}'
                        },
                    @endforeach
                ]
            }
        ],
        drilldown: {
            series: [
                @foreach($nationalstatus as $nationalstate)
                    {
                    name: '{{ $nationalstate->name }}',
                    id: '{{ $nationalstate->name }}',
                    data: [
                        <?php $gendervalues = getIncidentNumbersByGender($nationalstate->nationastatusid); ?>
                        @foreach($gendervalues as $gender)
                        [
                            '{{ $gender->gendername }}',
                            {{ $gender->incidents }}
                        ],
                        @endforeach
                    ]
                },
                @endforeach
            ]
        }
    });

</script>

<script type="text/javascript">
    // Data retrieved from https://www.ssb.no/energi-og-industri/olje-og-gass/statistikk/sal-av-petroleumsprodukt/artikler/auka-sal-av-petroleumsprodukt-til-vegtrafikk
    Highcharts.chart('regions', {
        title: {
            text: 'Incidents per Region vs Gender',
            align: 'left'
        },
        xAxis: {
            categories: [
                @foreach($regions as $region)
                    '{{ $region->region }}',
                @endforeach
            ]
        },
        yAxis: {
            title: {
                text: 'Incidents'
            }
        },
        tooltip: {
            valueSuffix: ' incidents'
        },
        plotOptions: {
            series: {
                borderRadius: '25%'
            }
        },
        series: [
            @foreach($genderdata as $sex)
                {
                    type: 'column',
                    name: '{{ $sex->gendername }}',
                    data: [59, 83, 65, 228,]
                },
            @endforeach
            {
            type: 'pie',
            name: 'Total',
            data: [{
                name: '2020',
                y: 619,
                color: Highcharts.getOptions().colors[0], // 2020 color
                dataLabels: {
                    enabled: true,
                    distance: -50,
                    format: '{point.total} M',
                    style: {
                        fontSize: '15px'
                    }
                }
            }, {
                name: '2021',
                y: 586,
                color: Highcharts.getOptions().colors[1] // 2021 color
            }],
            center: [75, 65],
            size: 100,
            innerSize: '70%',
            showInLegend: false,
            dataLabels: {
                enabled: false
            }
        }]
    });

</script>
@endsection
