<!DOCTYPE html>
<html lang="en">
    @include('index.head')
    <body>
        @include('index.navigation')
        <main id="main">
            <div id="map" style="height: 500px;"></div>
            <section id="clients" class="clients">
                <div class="container" data-aos="zoom-in">

                    <div class="row d-flex align-items-center">

                        <div class="col-lg-2 col-md-4 col-6">
                            <img src="{{ asset('assets/img/unfpa.png') }}" class="img-fluid" alt="">
                        </div>

                        <div class="col-lg-2 col-md-4 col-6">
                            <img src="{{ asset('assets/img/undp.png') }}" class="img-fluid" alt="">
                        </div>

                    </div>

                </div>
            </section><!-- End Clients Section -->

        </main><!-- End #main -->

        @include('index.footer')
    </body>
    <script>
        var map = L.map('map').setView([1.3733, 32.2903], 7);
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
        }).addTo(map);

        // Make an AJAX request to the PHP endpoint to fetch participant counts
        $.ajax({
            url: "{{ route('/index/mapdata') }}", // Replace with the actual URL
            dataType: 'json',
            success: function (data) {
                data.forEach(function (participantData) {
                    if (participantData.latitudes && participantData.longitudes){
                        var latitude = participantData.latitudes;
                        var longitude = participantData.longitudes;
                        var count = participantData.incidents;

                        // Determine the icon class based on count ranges
                        var iconClass = 'rounded-badge';

                        if (count < 10) {
                            iconClass += ' low';
                        } else if (count < 50) {
                            iconClass += ' medium';
                        } else {
                            iconClass += ' high';
                        }

                        // Create a marker with the rounded badge
                        var marker = L.marker([latitude, longitude], {
                            icon: L.divIcon({
                                className: iconClass,
                                html: '<div class="badge"><strong>' + count + '</strong></div>', // You can change the Font Awesome icon class
                                iconSize: [40, 35] // Adjust the size as needed
                            })
                        });

                        marker.addTo(map);
                    }
                });
            },
            error: function (error) {
                console.log('Error fetching participant data: ' + error);
            }
        });

    </script>
</html>
