<!DOCTYPE html>
<html lang="en">

@include('index.head')

<body>

  @include('index.navigation')

  <main id="main">
    <!-- ======= About Section ======= -->
    <section id="about" class="about">
      <div class="container">

        <div class="row">
          <div class="col-lg-4 order-1 order-lg-2" data-aos="fade-left">
            <img src="assets/img/violence.jpg" class="img-fluid" alt="">
          </div>
          <div class="col-lg-3 order-1 order-lg-2" data-aos="fade-left">
          <div class="login-card card-block auth-body mr-auto ml-auto">
                <form method="POST" action="{{ route('login') }}">
                    @csrf
                    <div class="auth-box">
                        <div class="row m-b-20">
                            <div class="col-md-12">
                                <h6 class="text-left txt-primary">Login In</h6>
                            </div>
                        </div>
                        <hr/>
                        <div class="form-group row">
                            <label for="email" class="col-md-4 col-form-label text-md-right">{{ __('Username:') }}</label>
                            <div class="col-md-8">
                                <input id="email" type="email" class="form-control" placeholder="Username or Email" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>
                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <br/>
                        <div class="form-group row">
                            <label for="password" class="col-md-4 col-form-label text-md-right">{{ __('Password:') }}</label>

                            <div class="col-md-8">
                                <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password" placeholder="Password">

                                @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="row m-t-30">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary btn-md btn-block waves-effect text-center m-b-20">Sign in</button>
                            </div>
                        </div>
                        <hr/>

                    </div>
                </form>
            </div>
          </div>
          <div class="col-lg-5 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
            <h3>About NGBVD.</h3>
            <p class="fst-italic">
              Ministry of Gender Labour and Social Development is a Government Ministry with a responsibility to empower communities in diverse areas. The Ministry promotes cultural growth, skills development and labour productivity while promoting gender equality, labour administration, social protection and transformation of communities
            </p>
            <p>
              This Ministry commonly call Ministry of Gender has one of its major tasks to ensure that all Ugandans enjoy  better standards of living, especially the disadvantages  and vulnerable groups.
            </p>
            <p>
              The Ministry came into being by a constitutional requirement of the 1995 Constitution, Chapters 4 and 16 which mandates government to: “empower communities to harness their potential through skills development, Labour productivity and cultural growth.” The constitution advocates for protection and promotion of fundamental rights of the poor and other vulnerable groups as well as institutions of traditional or cultural leaders.
            </p>
            <p>
              It is comprised of the Social Development Sector (SDS) that promotes issues of social protection, gender equality, equity, human rights, culture, decent work conditions and empowerment for different groups such as women, children, the unemployed youth, internally displaced persons, the older persons and persons with disabilities.
            </p>
          </div>
        </div>

      </div>
    </section><!-- End About Section -->

    <!-- ======= Why Us Section ======= -->
    <section id="why-us" class="why-us">
      <div class="container">

        <div class="row">

          <div class="col-lg-4" data-aos="fade-up">
            <div class="box">
              <span>01</span>
              <h4>Vision</h4>
              <p></p>
            </div>
          </div>

          <div class="col-lg-4 mt-4 mt-lg-0" data-aos="fade-up" data-aos-delay="150">
            <div class="box">
              <span>02</span>
              <h4>Mission</h4>
              <p></p>
            </div>
          </div>

          <div class="col-lg-4 mt-4 mt-lg-0" data-aos="fade-up" data-aos-delay="300">
            <div class="box">
              <span>03</span>
              <h4> Goal</h4>
              <p></p>
            </div>
          </div>

        </div>

      </div>
    </section><!-- End Why Us Section -->

    <!-- ======= Clients Section ======= -->
    <section id="clients" class="clients">
      <div class="container" data-aos="zoom-in">

        <div class="row d-flex align-items-center">

          <div class="col-lg-2 col-md-4 col-6">
            <img src="assets/img/unfpa.png" class="img-fluid" alt="">
          </div>

          <div class="col-lg-2 col-md-4 col-6">
            <img src="assets/img/undp.png" class="img-fluid" alt="">
          </div>

        </div>

      </div>
    </section><!-- End Clients Section -->

  </main><!-- End #main -->

  @include('index.footer')

</body>

</html>