<!--Incident Information-->
<div class="row">
    <legend>Incident information</legend>
    <div class="col-sm-6" id="home1">
        <div class="form-group row">
            <label class="col-md-4 col-form-label text-md-left">Incident Date: <span class="text-danger">*</span></label>
            <div class="col-md-8">
                <input type="date" class="form-control" name="incident_date" id="incident_date" required>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-md-4 col-form-label text-md-left">Incident Time: <span class="text-danger">*</span></label>
            <div class="col-md-8">
                <select id="interview_time" class="form-control search-select" name="incident_time" required>
                    <option value="">Choose One</option>
                    @foreach($times as $time)
                    <option value="{{$time->id}}">{{$time->name}}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-md-4 col-form-label text-md-left">Reported By ?: <span class="text-danger">*</span></label>
            <div class="col-md-8">
                <select id="reportedby" class="form-control search-select" name="reportedby" required>
                    <option value="">Choose One</option>
                    @foreach($authorities as $authorities)
                        <option value="{{$authorities->id}}">{{$authorities->name}}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-md-4 col-form-label text-md-left">Contact:
                <span class="text-danger" style="visibility: hidden">*</span></label>
            <div class="col-md-8">
                <input type="text" class="form-control" name="reportedbycontact" id="reportedbycontact"  placeholder="Reported by contact">
            </div>
        </div>
        <div class="form-group row">
            <label class="col-md-4 col-form-label text-md-left">Place of Occurrence: <span class="text-danger">*</span></label>
            <div class="col-md-8">
                <select id="placeoccured" class="form-control search-select" name="placeoccured" required>
                    <option value="">Choose One</option>
                    @foreach($places as $place)
                        <option value="{{$place->id}}">{{$place->name}}</option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>
    <div class="col-sm-6" id="home1">
        <div class="form-group row">
            <label class="col-sm-4 control-label">District: <span class="text-danger">*</span></label>
            <div class="col-sm-8">
                <select id="district" class="form-control search-select" name="districtid" required>
                    <option value="">Choose One</option>
                    @foreach($districts as $district)
                    <option value="{{$district->id}}">{{$district->name}}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-sm-4 control-label">Sub-County: <span class="text-danger">*</span></label>
            <div class="col-md-8" id="subcounty">
                <select id="subcountyid" class="form-control search-select" name="subcountyid" required>
                    <option value="">Choose One</option>
                    @foreach($subcounties as $subcounty)
                        <option value="{{$subcounty->id}}">{{$subcounty->name}}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-sm-4 control-label">Parish: <span class="text-danger">*</span></label>
            <div id="parish" class="col-md-8">
                <select id="parishid" class="form-control search-select" name="parishid" required>
                    <option value="">Choose One</option>
                    @foreach($parishes as $parish)
                        <option value="{{$parish->id}}">{{$parish->name}}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-sm-4 control-label">Village:</label>
            <div class="col-md-8">
                <input type="text" class="form-control" name="village" placeholder="Village">
            </div>
        </div>
    </div>
</div>
<div class="row">
    <legend>Incidents</legend>
    @foreach($incidents as $incidents)
        <div class="col-sm-4" id="home1">
            <input type="checkbox" class="checkbox checkbox-inline" value="{{$incidents->id}}" name="incidentid[]"> {{$incidents->name}}
        </div>
    @endforeach
</div>
<div class="row">
    <div class="col-sm-12" id="home1">
        <label class="col-sm-2 col-form-label">Details</label>
        <div class="col-sm-12">
            <textarea rows="5" cols="5" class="form-control" name="notes" placeholder="Incident Details"></textarea>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function(){
        $(document).on('change', '#district', function(){
            var districtid = $(this).val();
            var select = $(this).parent();

            console.log(districtid);
            var opt = " ";
            $.ajax({
                type: 'get',
                url: "{{ route('/findSubcounty') }}",
                data: {'id':districtid},
                success: function(data){
                    //console.log('successful');
                    console.log(data);
                    //console.log(data.length);
                    opt+='<select id="subcountyid" class="form-control search-select" name="subcountyid" >';
                    opt+='<option value="" selected="selected">Choose One</option>';
                    for (var i = 0; i < data.length; i++) {
                        opt+='<option value="'+data[i].id+'"> '+data[i].name+'</option>';
                    }
                    opt+='</select>';

                    $("#subcounty").html("");
                    $("#subcounty").append(opt);
                },
                error: function(){
                    console.log('Failed');
                }
            });
        });

        $(document).on('change', '#subcountyid', function(){
            var subcountyid = $(this).val();
            var select = $(this).parent();

            console.log(subcountyid);
            var opt = " ";
            $.ajax({
                type: 'get',
                url: "{{ route('/findParish') }}",
                data: {'id':subcountyid},
                success: function(data){
                    //console.log('successful');
                    console.log(data);
                    //console.log(data.length);
                    opt+='<select class="form-control search-select" name="parishid" >';
                    opt+='<option value="" selected="selected">Choose One</option>';
                    for (var i = 0; i < data.length; i++) {
                        opt+='<option value="'+data[i].id+'"> '+data[i].name+'</option>';
                    }
                    opt+='</select>';
                    $("#parish").html("");
                    $("#parish").append(opt);
                },
                error: function(){
                    console.log('Failed');
                }
            });
        });

        $(document).on('change', '#parishid', function(){
            var parishid = $(this).val();
            var select = $(this).parent();

            console.log(parishid);
            var opt = " ";
            $.ajax({
                type: 'get',
                url: "{{ route('/findVillage') }}",
                data: {'id':parishid},
                success: function(data){
                    //console.log('successful');
                    console.log(data);
                    //console.log(data.length);
                    opt+='<select class="form-control search-select" name="village" >';
                    opt+='<option value="" selected="selected">Choose One</option>';
                    for (var i = 0; i < data.length; i++) {
                        opt+='<option value="'+data[i].id+'"> '+data[i].name+'</option>';
                    }
                    $("#village").html("");
                    $("#village").append(opt);
                },
                error: function(){
                    console.log('Failed');
                }
            });
        });

        $(document).on('change', '#pwd', function(){
            var pwdid = $(this).val();
            var select = $(this).parent();
            var opt = " ";
            if(pwdid == 1){
                console.log(pwdid);
                $.ajax({
                    type: 'get',
                    url: "{{ route('/findDisability') }} ",
                    data: {'id':pwdid},
                    success: function(data){
                        //console.log('successful');
                        console.log(data);
                        //console.log(data.length);
                        opt+='<label class="col-sm-4 control-label">Disability:</label>';
                        opt+='<div class="col-md-8">';
                        opt+='<select class="form-control search-select" name="village" >';
                        for (var i = 0; i < data.length; i++) {
                            opt+='<option value="'+data[i].id+'"> '+data[i].name+'</option>';
                        }
                        opt+='</div>';
                        $("#disability").html("");
                        $("#disability").append(opt);
                    },
                    error: function(){
                        console.log('Failed');
                    }
                });
            }else{
                $("#disability").html("");
                $("#disability").append(opt);
            }
        });
    });
</script>
