@extends('layouts.app')
<?php
//ini_set('memory_limit', '2048M');
$request = request();
?>
@section('content')
    <style>
        .pagination {
            font-size: 12px;
        }

        .pagination > li > a,
        .pagination > li > span {
            padding: 4px 8px;
            box-sizing: border-box;
        }
    </style>
<div class="pcoded-content">
    <div class="pcoded-inner-content">
        <div class="main-body">
            <div class="page-wrapper">
                <!-- Page-header start -->
                <div class="page-header card page-body">
                    <div class="row align-items-end">
                        <div class="col-lg-8">
                            <div class="page-header-title">
                                <i class="icofont icofont icofont icofont-file-document bg-c-pink"></i>
                                <div class="d-inline">
                                    <h4></h4>
                                    <span>Victim Records</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="page-header-breadcrumb">
                                <ul class="breadcrumb-title">
                                    <li class="breadcrumb-item">
                                        <a href="index.html">
                                            <i class="icofont icofont-home"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item"><a href="#!">Incident Records</a>
                                    </li>
                                    <li class="breadcrumb-item"><a href="#!">Victim Records</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="table-responsive">
                        <!-- Records per page selection -->
                        <form method="get" action="{{ route('/dataentry/list') }}">
                            <label for="perPage">Records per page:</label>
                            <select name="perPage" id="perPage" onchange="this.form.submit()" style="width: 100px;">
                                @foreach ($availablePerPageOptions as $option)
                                    <option value="{{ $option }}" @if($perPage == $option) selected @endif>{{ $option }}</option>
                                @endforeach
                                <!-- Add more options as needed -->
                            </select>
                        </form>
                        

                        <table class="table table-hover" id="table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>CRB #</th>
                                    <th>Interview Date</th>
                                    <th>Survivor Code</th>
                                    <th>Gender</th>
                                    <th>Age</th>
                                    <th>Nationality</th>
                                    <th>National Status</th>
                                    <th>District</th>
                                    <th>Sub-County</th>
                                    <th>Parish</th>
                                    <th>Reffered</th>
                                    <th><i>i</i></th>
                                </tr>
                            </thead>
                            <tbody>
                               <?php
                               $key = 1;?>
                               @foreach ($victims as $victim)
                                <tr>
                                   <td><a href="<?php echo url('/dataentry/update?id='.base64_encode($victim->id).'')?>"> <?= $key; ?> </a></td>
                                   <td><a href="<?php echo url('/dataentry/update?id='.base64_encode($victim->id).'')?>"> <?php echo $victim->crb_number; ?> </a></td>
                                   <td><?php echo $victim->interview_date; ?></td>
                                   <td><?php echo $victim->survivor_code; ?></td>
                                   <td><?php echo $victim->genderValue; ?></td>
                                   <td><?= $victim->dob == "0000-00-00" ? "" : $victim->dob; ?></td>
                                   <td><?php echo $victim->nationality; ?></td>
                                   <td><?php echo $victim->national_status; ?></td>
                                   <td><?php echo $victim->district; ?></td>
                                   <td><?php echo $victim->subbcounty; ?></td>
                                   <td><?php echo $victim->parish; ?></td>
                                   <td><?= !in_array($victim->refered, array(1, 0)) ? 'No' : ($victim->refered == 1 ? 'Yes' : 'No'); ?></td>
                                   <td>
                                       <a href="<?php echo url('/dataentry/update?id='.base64_encode($victim->id)); ?>" class="ti-pencil"></a>
                                    </td>
                                </tr>
                                <?php $key++ ?>
                               @endforeach
                            </tbody>
                        </table>
                        <!-- Pagination row -->

                        <!-- Display the pagination links with appended query parameters -->
                        {{ $victims->appends(request()->query())->links('vendor.pagination.bootstrap-4', ['class' => 'custom-pagination']) }}

                    </div>
                </div>
                <!-- Page-header end -->
            </div>
        </div>
    </div>
</div>
    <script>
        // Handle the onchange event of the select input
        document.getElementById('perPage').addEventListener('change', function() {
            var perPage = this.value;
            var currentUrl = window.location.href;
            var updatedUrl = currentUrl + '?perPage=' + perPage;
            window.location.href = updatedUrl;
        });
    </script>
@endsection
