<!--General Information-->
<div class="row">
    <legend>General information</legend>
    <div class="col-sm-6" id="home1">
        <div class="form-group row">
            <label class="col-md-4 col-form-label text-md-left">CRB Number </label>
            <div class="col-md-8">
                <input type="text" class="form-control" name="crb_number" id="crb_number" placeholder="GBV/00/00/0000" >
            </div>
        </div>
        <div class="form-group row">
            <label class="col-md-4 col-form-label text-md-left">Interview Date </label>
            <div class="col-md-8">
                <input type="date" class="form-control" name="interview_date" id="interview_date" >
            </div>
        </div>
        <div class="form-group row">
            <label class="col-md-4 col-form-label text-md-left">Interview Time </label>
            <div class="col-md-8">
                <select id="interview_time" class="form-control search-select" name="interview_time" required>
                    <option value="">Choose One</option>
                    @foreach($times as $time)
                    <option value="{{$time->id}}">{{$time->name}}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-md-4 col-form-label text-md-left">Refered ? </label>
            <div class="col-md-8">
                <input type="checkbox" class="checkbox checkbox-inline" value="1" name="reffered" id="reffered"> Yes
            </div>
        </div>
    </div>
    <div class="col-sm-6" id="home1">
        <div class="form-group row">
            <label class="col-sm-4 control-label">District: </label>
            <div class="col-sm-8">
                <select id="district" class="form-control search-select" name="districtid" required>
                    <option value="">Choose One</option>
                    @foreach($districts as $district)
                    <option value="{{$district->id}}">{{$district->name}}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-sm-4 control-label">Sub-County: </label>
            <div class="col-md-8" id="subcounty">
                <select id="subcountyid" class="form-control search-select" name="subcountyid" required>
                    <option value="">Choose One</option>
                    @foreach($subcounties as $subcounty)
                    <option value="{{$subcounty->id}}">{{$subcounty->name}}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-sm-4 control-label">Parish: </label>
            <div id="parish" class="col-md-8">
                <select id="parishid" class="form-control search-select" name="parishid" required>
                    <option value="">Choose One</option>
                    @foreach($parishes as $parish)
                    <option value="{{$parish->id}}">{{$parish->name}}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-sm-4 control-label">Village:</label>
            <div class="col-md-8">
               <input type="text" class="form-control" name="village" placeholder="Village" >
            </div>
        </div>
    </div>
</div>
<!--Survivor Information-->
<div class="row">
    <legend>Survivor information</legend>
    <div class="col-sm-6" id="home1">
        <div class="form-group row">
            <label class="col-md-4 col-form-label">Survivor Code: </label>
            <div class="col-md-8">
                <input type="text" class="form-control" name="survivor_code" placeholder="Survivor Code" >
            </div>
        </div>
        <div class="form-group row">
            <label class="col-md-4 col-form-label text-md-left">NIN</label>
            <div class="col-md-8">
                <input type="text" class="form-control" name="nin" placeholder="NIN number" >
            </div>
        </div>
        <div class="form-group row">
            <label class="col-md-4 col-form-label text-md-left">Gender </label>
            <div class="col-md-4 text-md-left">
                <input type="radio" class="radio radio-inline" name="sex" > Male
            </div>
            <div class="col-md-4 text-md-left">
                <input type="radio" class="radio radio-inline" name="sex" > Female
            </div>
        </div>
        <div class="form-group row">
            <label class="col-md-4 col-form-label text-md-left">Nationality </label>
            <div class="col-md-8">
                <select id="nationality" class="form-control search-select" name="nationality" required>
                    <option value="">Choose One</option>
                    @foreach($nationality as $nationality)
                        <option value="{{$nationality->id}}">{{$nationality->name}}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-md-4 col-form-label text-md-left">Age </label>
            <div class="col-md-8">
                <input type="number" class="form-control" name="age" id="age" >
                <!-- <select id="national_status" class="form-control search-select" name="national_status" required>
                    <option value="">Choose One</option>
                    @foreach($agegroup as $agegroup)
                        <option value="{{$agegroup->id}}">{{$agegroup->name}}</option>
                    @endforeach
                </select> -->
            </div>
        </div>
        <div class="form-group row">
            <label class="col-md-4 col-form-label text-md-left">Nationality Status </label>
            <div class="col-md-8">
                <select id="national_status" class="form-control search-select" name="national_status" required>
                    <option value="">Choose One</option>
                    @foreach($status as $status)
                        <option value="{{$status->id}}">{{$status->name}}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-md-4 col-form-label text-md-left">Number of Children </label>
            <div class="col-md-8">
                <input type="number" class="form-control" name="number_children" id="number_children" >
            </div>
        </div>
    </div>
    <div class="col-sm-6" id="home1">
        <div class="form-group row">
            <label class="col-sm-4 control-label">Religion: </label>
            <div class="col-sm-8">
                <select id="religion" class="form-control search-select" name="religion" required>
                    <option value="">Choose One</option>
                    @foreach($religions as $religion)
                        <option value="{{$religion->id}}">{{$religion->name}}</option>
                    @endforeach
                </select>
                <div id="country_error"></div>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-sm-4 control-label">Marital Status: </label>
            <div class="col-md-8">
                <select id="marital_status" class="form-control search-select" name="marital_status" required>
                    <option value="">Choose One</option>
                    @foreach($mariage as $mariage)
                        <option value="{{$mariage->id}}">{{$mariage->name}}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-sm-4 control-label">Separed Children: </label>
            <div class="col-md-8">
                <input type="checkbox" class="checkbox checkbox-inline" name="separeted_children" id="separeted_children" value="1"> Yes
            </div>
        </div>
        <div class="form-group row">
            <label class="col-sm-4 control-label">PWD:</label>
            <div class="col-md-8">
                <input type="checkbox" class="checkbox checkbox-inline" class="form-control" name="pwd" id="pwd" value="1"> Yes
            </div>
        </div>
        <div class="form-group row">
            <label class="col-md-4 col-form-label text-md-left">Education</label>
            <div class="col-md-8">
                <input type="text" class="form-control" name="education" id="education" >
            </div>
        </div>
        <div class="form-group row">
            <label class="col-md-4 col-form-label text-md-left">Occupation</label>
            <div class="col-md-8">
                <input type="text" class="form-control" name="occupation" id="occupation">
            </div>
        </div>
    </div>
</div>
<!--Survivor Location-->
<div class="row">
    <legend>Previous Incident Numbers</legend>
    <div class="col-sm-12" id="home1">
        <div class="form-group row">
            <label class="col-md-2 col-form-label text-md-left">CRB Number</label>
            <div class="col-md-10">
                <input type="text" class="form-control" name="old_crb" id="old_crb" multiple="multiple">
            </div>
        </div>
    </div>

</div>
<script type="text/javascript">
    $(document).ready(function(){
        $(document).on('change', '#district', function(){
            var districtid = $(this).val();
            var select = $(this).parent();

            console.log(districtid);
            var opt = " ";
            $.ajax({
                type: 'get',
                url: 'findSubcounty',
                data: {'id':districtid},
                success: function(data){
                    //console.log('successful');
                    console.log(data);
                    //console.log(data.length);
                    opt+='<select id="subcountyid" class="form-control search-select" name="subcountyid" required>';
                    for (var i = 0; i < data.length; i++) {
                        opt+='<option value="'+data[i].id+'"> '+data[i].name+'</option>';
                    }
                    opt+='</select>';
                    
                    $("#subcounty").html("");
                    $("#subcounty").append(opt);
                },
                error: function(){
                    console.log('Failed');
                }
            });
        });

        $(document).on('change', '#subcountyid', function(){
            var subcountyid = $(this).val();
            var select = $(this).parent();

            console.log(subcountyid);
            var opt = " ";
            $.ajax({
                type: 'get',
                url: 'findParish',
                data: {'id':subcountyid},
                success: function(data){
                    //console.log('successful');
                    console.log(data);
                    //console.log(data.length);
                    opt+='<select class="form-control search-select" name="parishid" required>';
                    for (var i = 0; i < data.length; i++) {
                        opt+='<option value="'+data[i].id+'"> '+data[i].name+'</option>';
                    }
                    opt+='</select>';
                    $("#parish").html("");
                    $("#parish").append(opt);
                },
                error: function(){
                    console.log('Failed');
                }
            });
        });

        $(document).on('change', '#parishid', function(){
            var parishid = $(this).val();
            var select = $(this).parent();

            console.log(parishid);
            var opt = " ";
            $.ajax({
                type: 'get',
                url: 'findVillage',
                data: {'id':parishid},
                success: function(data){
                    //console.log('successful');
                    console.log(data);
                    //console.log(data.length);
                    opt+='<select class="form-control search-select" name="village" required>';
                    for (var i = 0; i < data.length; i++) {
                        opt+='<option value="'+data[i].id+'"> '+data[i].name+'</option>';
                    }
                    $("#village").html("");
                    $("#village").append(opt);
                },
                error: function(){
                    console.log('Failed');
                }
            });
        });
    });
</script>
